/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;

public class BlauFunk
implements DiscoveryListener {
    public static final int INI = 0;
    public static final int SUCHEN = 1;
    public static final int VERBUNDEN = 2;
    public static final int FEHLER = 3;
    private final int NXTID;
    private final int SERIALID;
    private LocalDevice local = null;
    private DiscoveryAgent agent = null;
    private RemoteDevice remote = null;
    private String remoteURL = null;
    private String remoteName = null;
    private int zustand = 0;
    private BlauFunkForm blauForm;

    public BlauFunk(BlauFunkForm b) {
        this.NXTID = 2048;
        this.SERIALID = 4353;
        this.blauForm = b;
        try {
            this.local = LocalDevice.getLocalDevice();
            this.agent = this.local.getDiscoveryAgent();
        }
        catch (BluetoothStateException bse) {
            System.out.println("no device found");
        }
    }

    public void herstellen() {
        if (this.local != null) {
            try {
                this.agent.startInquiry(10390323, (DiscoveryListener)this);
                this.blauForm.blauFortschritt("Searching for NXT Brick");
                this.zustand = 1;
            }
            catch (BluetoothStateException bse) {
                System.out.println("inquiry couldn't be started");
            }
        } else {
            this.blauForm.meldung("Bluetooth is off or this device doesn't support JSR82");
        }
    }

    public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
        if (cod.getMajorDeviceClass() == 2048) {
            this.remote = btDevice;
        }
    }

    public void inquiryCompleted(int discType) {
        if (this.remote == null) {
            this.blauForm.meldung("No NXT Brick found");
        } else {
            try {
                this.remoteName = this.remote.getFriendlyName(false);
                this.blauForm.blauFortschritt(new String("Connecting to " + this.remoteName));
            }
            catch (IOException ioe) {
                System.out.println("error retrieving friendly name");
            }
            try {
                UUID[] uuids = new UUID[]{new UUID(4353L)};
                this.agent.searchServices(null, uuids, this.remote, (DiscoveryListener)this);
            }
            catch (BluetoothStateException bse) {
                System.out.println("service search failed");
            }
        }
    }

    public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
        this.remoteURL = servRecord[0].getConnectionURL(0, false);
    }

    public void serviceSearchCompleted(int transID, int respCode) {
        if (respCode == 1) {
            this.zustand = 2;
            this.blauForm.setzeAdresse(this.remoteURL);
        } else {
            switch (respCode) {
                case 2: {
                    this.blauForm.meldung("Error: Service search terminated");
                    break;
                }
                case 3: {
                    this.blauForm.meldung("Error: Service search error");
                    break;
                }
                case 4: {
                    this.blauForm.meldung("Error: Service search no records");
                    break;
                }
                case 6: {
                    this.blauForm.meldung("Error: Service search device not reachable");
                }
            }
        }
    }

    public int istZustand() {
        return this.zustand;
    }

    public String istAdresse() {
        return this.remoteURL;
    }
}

