/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;

public class NxtVerbindung
extends Thread {
    private String remoteURL = null;
    private StreamConnection con;
    private InputStream mIn;
    private OutputStream mOut;
    private int[] empfangsPaket;
    boolean verbunden;

    public NxtVerbindung(String url) {
        this.remoteURL = url;
        this.verbunden = false;
    }

    public void run() {
        if (!this.verbunden) {
            try {
                this.con = (StreamConnection)Connector.open((String)this.remoteURL);
                this.mIn = this.con.openInputStream();
                this.mOut = this.con.openOutputStream();
                System.out.println("Device successfuly connected to: " + this.remoteURL);
                this.verbunden = true;
            }
            catch (IOException e) {
                System.err.println("Note: can't connect to: " + this.remoteURL);
                this.verbunden = false;
            }
        }
    }

    synchronized void schreibPaket(int[] paket) throws IOException {
        this.mOut.write(paket.length & 0xFF);
        this.mOut.write(paket.length >> 8);
        int i = 0;
        while (i < paket.length) {
            this.mOut.write(paket[i]);
            ++i;
        }
        this.mOut.flush();
    }

    synchronized void liesPaket() throws IOException {
        int anz = this.mIn.read();
        this.empfangsPaket = new int[anz += this.mIn.read() << 8];
        int i = 0;
        while (i < anz) {
            this.empfangsPaket[i] = this.mIn.read();
            ++i;
        }
    }

    synchronized void lsWrite(int port, int[] paket) {
        try {
            this.mOut.write(paket.length + 5);
            this.mOut.write(0);
            this.mOut.write(128);
            this.mOut.write(15);
            this.mOut.write(port);
            this.mOut.write(paket.length);
            this.mOut.write(1);
            int i = 0;
            while (i < paket.length) {
                this.mOut.write(paket[i]);
                ++i;
            }
            this.mOut.flush();
        }
        catch (IOException e) {
            System.err.println("Can't get value from LS device on port: " + (port + 1));
            this.verbunden = false;
        }
    }

    boolean setOutputState(int port, int power, int regMode, int ratio) {
        int[] nArray = new int[12];
        nArray[0] = 128;
        nArray[1] = 4;
        nArray[2] = port;
        nArray[3] = power;
        nArray[4] = 5;
        nArray[5] = regMode;
        nArray[6] = ratio;
        nArray[7] = 32;
        int[] paket = nArray;
        try {
            this.schreibPaket(paket);
            return true;
        }
        catch (IOException e) {
            System.err.println("Couldn't configure output" + (port + 1));
            this.verbunden = false;
            return false;
        }
    }

    boolean setInputMode(int port, int type, int mode) {
        int[] paket = new int[]{128, 5, port, type, mode};
        try {
            this.schreibPaket(paket);
            return true;
        }
        catch (IOException e) {
            System.err.println("Couldn't configure sensor port" + (port + 1));
            this.verbunden = false;
            return false;
        }
    }

    int getInputValue(int sensor) {
        int[] nArray = new int[3];
        nArray[1] = 7;
        nArray[2] = sensor;
        int[] paket = nArray;
        try {
            this.schreibPaket(paket);
            this.liesPaket();
            return this.empfangsPaket[11] * 256 + this.empfangsPaket[10];
        }
        catch (IOException e) {
            System.err.println("Can't get value from sensor: " + (sensor + 1));
            this.verbunden = false;
            return 0;
        }
    }

    int lsGetStatus(int port) {
        int[] nArray = new int[3];
        nArray[1] = 14;
        nArray[2] = port;
        int[] paket = nArray;
        try {
            this.schreibPaket(paket);
            this.liesPaket();
            return this.empfangsPaket[3];
        }
        catch (IOException e) {
            System.err.println("Can't get value from LS device on port: " + (port + 1));
            this.verbunden = false;
            return 0;
        }
    }

    int lsRead(int port) {
        int[] nArray = new int[3];
        nArray[1] = 16;
        nArray[2] = port;
        int[] paket = nArray;
        try {
            this.schreibPaket(paket);
            this.liesPaket();
            return this.empfangsPaket[4];
        }
        catch (IOException e) {
            System.err.println("Can't get value from LS device on port: " + (port + 1));
            this.verbunden = false;
            return 0;
        }
    }

    int getBatteryLevel() {
        int[] nArray = new int[2];
        nArray[1] = 11;
        int[] paket = nArray;
        try {
            this.schreibPaket(paket);
            this.liesPaket();
            return (this.empfangsPaket[4] << 8) + this.empfangsPaket[3];
        }
        catch (IOException e) {
            System.err.println("Can't get battery value");
            this.verbunden = false;
            return 0;
        }
    }

    public void close() {
        try {
            this.verbunden = false;
            this.mIn.close();
            this.mOut.close();
            this.con.close();
        }
        catch (IOException e) {
            System.err.println("Can't close connection");
        }
    }
}

